<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateNotificationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('notifications', function (Blueprint $table) {
            // Add missing columns that are defined in the Notification model
            if (!Schema::hasColumn('notifications', 'title')) {
                $table->string('title')->nullable()->after('user_id');
            }

            if (!Schema::hasColumn('notifications', 'admin_id')) {
                $table->integer('admin_id')->nullable()->after('user_id');
            }

            if (!Schema::hasColumn('notifications', 'type')) {
                $table->string('type')->default('info')->after('message');
            }

            if (!Schema::hasColumn('notifications', 'is_read')) {
                $table->boolean('is_read')->default(false)->after('type');
            }

            if (!Schema::hasColumn('notifications', 'source_id')) {
                $table->integer('source_id')->nullable()->after('is_read');
            }

            if (!Schema::hasColumn('notifications', 'source_type')) {
                $table->string('source_type')->nullable()->after('source_id');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('notifications', function (Blueprint $table) {
            $table->dropColumn([
                'title',
                'admin_id',
                'type',
                'is_read',
                'source_id',
                'source_type'
            ]);
        });
    }
}
